
/*
 *
 * cli_parser.c -- Traffic Squeezer CLI parser code
 *
 * Author: Kiran K (2006-2008)
 *         kiran_cyberpro at yahoo dot com
 *
 *
 * Traffic Squeezer is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * Traffic Squeezer is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Zebra; see the file COPYING.  If not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */



#include "cli_parser.h"

void usage()
{
        printf("Traffic Squeezer - Usage\n");
        printf("trafficsqueezer [-i <ingress port> -e <egress port>]\n");
        printf("                [-f <configuration file>]\n");

}

int parse(int argc, char **argv)
{
    if(argc<=1)
    {
	if(parse_config(DEFAULT_CONFIG_FILE_PATH)==FALSE) /* Added: Kiran 25_May_07 */
        {
        	printf("ERR: Traffic Squeezer default config file not found\n\n");
		usage();
	        return FALSE;
        }
	else
		return TRUE;

        return TRUE;
    }

    {//[-f <configuration file>]
        if(!strcmp(argv[1], "-f"))
        {
            if(argc==3)
            {
		/* Parser the configuration file and retrieve values */
		if(parse_config(argv[2])==FALSE) /* Added: Kiran 25_May_07 */
		{
			printf("ERR: Traffic Squeezer config file not found\n");
			return FALSE;
		}
		return TRUE;
            }
            else
            {   usage();
                return FALSE;
            }

        }
    }

    {// [-i <ingress port> -e <egress port>]
        if(!strcmp(argv[1],"-i"))
        {   if(argc==5)
            {   //printf("ingress port selected = %s\n", argv[2]);
                strcpy(ingress_port, argv[2]);
            }
            else
            {   usage();
                return FALSE;
            }

            if(!strcmp(argv[3], "-e"))
            {
                //printf("egress port selected = %s\n", argv[4]);
                strcpy(egress_port, argv[4]);
            }
            else
            {
                usage();
                return FALSE;
            }
	    return TRUE;
        }
        if(!strcmp(argv[1],"-e"))
        {   if(argc==5)
            {   //printf("egress port selected = %s\n", argv[2]);
                strcpy(egress_port, argv[2]);
            }
            else
            {   usage();
                return FALSE;
            }

            if(!strcmp(argv[3], "-i"))
            {
                //printf("ingress port selected = %s\n", argv[4]);
                strcpy(ingress_port, argv[4]);
            }
            else
            {
                usage();
                return FALSE;
            }
	    return TRUE;
        }
    }

    usage();
    return FALSE;
}





