/*
 *
 * bucket.h -- Traffic Squeezer Payload Coalescing bucket management code.
 *
 * Author: Kiran K (2006-2008)
 *         kiran_cyberpro at yahoo dot com
 *
 *
 * Traffic Squeezer is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * Traffic Squeezer is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Zebra; see the file COPYING.  If not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef _BUCKET_
#define _BUCKET_

#include "common.h"

#define MAX_BUCKET_PDU_SIZE	300  /* A bucket can hold a max. bytes */
#define MAX_BUCKET_PDU          10    /* max no. of bucket PDUs */
#define MAX_BUCKET_HDR  30  /* Maximum bucket header length */
typedef struct ts_bucket_ {
    BYTE pdu_cnt;		      /* Count of number of PDUs in the bucket */ 		
    BYTEx2 pdu_size[MAX_BUCKET_PDU]; /* Using a fixed array instead a linked list for good performance */
    BYTE payload[ETH2_MAX_MTU];   /* Bucket PDUs buffer */
    BYTEx2 size;
    BYTE ts_bucket_hdr[MAX_BUCKET_HDR]; 
		/* Format: [BYTEx2 size_pkt-n] ...[BYTEx2 size_pkt-2][BYTEx2 size_pkt-1][BYTEx1 pkt_cnt] */
}ts_bucket_t;

/* adds a fresh PDU into the new/existing bucket (used: Ingress Cycle) */
int add_bucket_PDU(IN unsigned char *in_buff, IN size_t in_buff_size, OUT ts_bucket_t *bucket);

/* gets the final Coalesced PDU from the bucket for Tx (used: Ingress Cycle) */
int get_bucket_PDU(IN ts_bucket_t *bucket, OUT unsigned char *out_buff, OUT size_t *out_buff_size);

/* gets the pre-coalesced PDU and extracts multiple PDUs in a bucket (used: Egress Cycle) */
int get_bucket_PDUs( IN unsigned char *in_buff, IN size_t in_buff_size, OUT ts_bucket_t *bucket);

/* cleans the whole bucket contents */
int clean_bucket(INOUT ts_bucket_t *bucket);

#endif
