/*
 *
 * file_parser.h -- Traffic Squeezer config file parser code
 *
 * Author: Kiran K (2006-2008)
 *         kiran_cyberpro at yahoo dot com
 *
 *
 * Traffic Squeezer is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * Traffic Squeezer is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Zebra; see the file COPYING.  If not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */


/* file_parser.h - Changelog
 * Initial Version (25_May_07) - Debaranjan
 *
 * Updated (26_May_07) - Kiran
 *  Modified file parsing code into reusable APIs
 *
 */

#ifndef __FILE_PARSER__
#define __FILE_PARSER__

#include<stdio.h>
#include<string.h>
#include<stdlib.h>
#include<ctype.h>

#include "common.h"

#define MAX_BUF 100
#define CFG_PRM_NAME_MAX_LEN 20


extern char ingress_port[10];
extern char egress_port[10];

typedef struct cfg_prm_ { //Added: 02_Jun_07: Kiran
	char prm_name[CFG_PRM_NAME_MAX_LEN];
	size_t prm_len;
}cfg_prm_t;

#define CFG_PRM_INGRESS_PORT 0
#define CFG_PRM_EGRESS_PORT 1




int parse_config(char *config_file);

char* cmd_make_str (const char *string);

#endif

