/*
 *
 * web.c -- Traffic Squeezer HTTP Web Interface Handler Code
 *
 * Author: Kiran K (2006-2008)
 *         kiran_cyberpro at yahoo dot com
 *
 *
 * Traffic Squeezer is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * Traffic Squeezer is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Zebra; see the file COPYING.  If not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include <stdio.h>
#include "web.h"


extern char ingress_port[10];
extern char egress_port[10];

extern int compress_enabled;
extern int coalescing_enabled;
extern int qos_enabled;
extern BYTEx2 bucket_size;

void *web_thread_start(void *a)
{

    while(TRUE)
    {
        usleep(10);
        swill_serve();
    }
}



void web_get_intro_title(FILE *f)
{

	fprintf(f,
           "<html><body><img align=left src=\"TS_Reflej_8.png\"> \
            <table border=0 cellpadding=0 cellspacing=0 \
                align=right vspace=1 style=\"font-family:verdana;font-size:80%\"> \
		<tr><td>Version </td><td> %s</td></tr> \
                <tr><td>Author</td><td> Kiran. K</td><tr><tr><td>Release Date </td><td> %s</td></tr> \
            <tr><td>Copyright </td><td> 2006-2008</td></tr> \
            <tr><td>Project Website%s</td><td><a href=\"http://trafficsqueezer.sourceforge.net\"> \
                 http://trafficsqueezer.sourceforge.net</a></td></tr></table> \
             <br><br><br><br><br><br><hr>\n", TRAFFIC_SQUEEZER_VERSION, RELEASE_DATE, HTTP_TAB);

}


void print_html_help(FILE *f)
{
   web_get_intro_title(f);

   fprintf(f, "<font size=\"+1\" face=\"Verdana\" color=AA5088>\
                <center><u><b>Traffic Squeezer - Help</b></u></center></font><br>\n");

   fprintf(f, "<div style=\"position:absolute;left:20;top:200;width:95%;height:280;\" \
		<table width=\"100%\" height=\"100%\" border=1 cellpadding=0 cellspacing=0><tr valign=\"top\"> \
		<td bgcolor=\"FFFFCC\">\
		<iframe height=\"100%\" width=\"100%\" src=\"help_content.html\"></iframe>\
		</td>\
		</tr></table></div>\n");
   
   fprintf(f, "<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><hr>\n");
   fprintf(f, "<table border=0> \
                <tr> \
                        <td><center><a href=\"intro.html\"><img border=0 src=\"home.png\"></a></center></td> \
			<td><center><a href=\"settings.html\"><img border=0 src=\"configure.png\"></img></a></center></td> \
                        <td><center><a href=\"main_stats.html\"><img border=0 src=\"stats.png\"></a></center></td> \
                        <td><center><img border=0 src=\"help.png\"></center></td> \
                </tr> \
                <tr> \
                        <td><center>Home</center></td> \
			<td><center>Settings</center></td> \
                        <td><center>Statistics</center></td> \
                        <td bgcolor=FF9933><center><b>Help</b></center></td> \
                </tr> \
                </table><br>");
   fprintf(f, "</body></html>\n");
}

void print_html_main_stats(FILE *f)
{
   web_get_intro_title(f);

   fprintf(f, "<font size=\"+1\" face=\"Verdana\" color=AA5088>\
                <center><u><b>Traffic Squeezer - Statistics</b></u></center></font><br>\n");

   fprintf(f, "<table border=0 cellpadding=0 cellspacing=0 style=\"font-family:verdana;font-size:90%\">");
   fprintf(f, "<ul>"); //bulled lists
   if(compress_enabled==TRUE)
	fprintf(f, "<tr><td><li><b><a href=\"comp_stats.html\">View Compression Statistics</a></b><br><br></td></tr>\n");
   else
	fprintf(f, "<tr><td><b><font color=gray><li>View Compression Statistics (Disabled)</font></b><br></td></tr>\n");

   if(coalescing_enabled==TRUE)	
   	fprintf(f, "<tr><td><li><b><a href=\"coal_stats.html\">View Coalescing Statistics</a></b><br><br></td></tr>\n");
   else
	   fprintf(f, "<tr><td><b><font color=gray><li>View Coalescing Statistics (Disabled)</font></b><br></td></tr>\n");

   if(qos_enabled==TRUE)
        fprintf(f, "<tr><td><li><b><a href=\"qos_stats.html\">View QoS Statistics</a></b><br><br></td></tr>\n");
   else
           fprintf(f, "<tr><td><b><font color=gray><li>View QoS Statistics (Disabled)</font></b><br></td></tr>\n");


   fprintf(f, "</ul>");

   fprintf(f, "</table><br>\n");

   fprintf(f, "<br><br><br><br><hr>\n");

   fprintf(f, "<table border=0> \
                <tr> \
                        <td><center><a href=\"intro.html\"><img border=0 src=\"home.png\"></img></a></center></td> \
                        <td><center><a href=\"settings.html\"><img border=0 src=\"configure.png\"></img></a></center></td> \
                        <td><center><img border=0 src=\"stats.png\"></img></center></td> \
                        <td><center><a href=\"help.html\"><img border=0 src=\"help.png\"></img></a></center></td> \
                </tr> \
                <tr> \
                        <td><center>Home</center></td> \
                        <td><center>Settings</center></td> \
                        <td bgcolor=FF9933><center><b>Statistics</b></center></td> \
                        <td><center>Help</center></td> \
                </tr> \
                </table><br>");
   fprintf(f, "</body></html>\n");

}

void print_html_conf_coal(FILE *f)
{
   //dump_request(stderr);
   web_get_intro_title(f);

   char *new_bucket_size = NULL;
   char *conf_sub = NULL;

   char on[5];
   strcpy(on, "on");

   if(swill_getargs("s(conf_sub)", &conf_sub)){} //Read the values
   if(swill_getargs("s(new_bucket_size)", &new_bucket_size)) {}

   if(conf_sub != NULL)
   {
	if(new_bucket_size == NULL)
	{
		/* do nothing */
	}
	else
	{	/* change the global bucket size */
		BYTEx2 temp_size = (BYTEx2)atoi(new_bucket_size);
		if( (temp_size>=60) && (temp_size<=1420) )
		bucket_size = temp_size;
	}
   }



   fprintf(f, "<font size=\"+1\" face=\"Verdana\" color=AA5088>\
                <center><u><b>Traffic Squeezer - Configure Coalescing</b></u></center></font><br>\n");

   fprintf(f, "<table border=0 cellpadding=0 cellspacing=0 style=\"font-family:verdana;font-size:90%\">");
   fprintf(f, "<tr><td><b>Configure:</b><br></td></tr> \
	       <tr><td><form action=\"http://127.0.0.1:8080/conf_coal.html\" method=POST>\n");

   fprintf(f, "<table border=0>");



   fprintf(f, "<tr><td>Bucket Size</td><td></td>\
		<td><input type=\"text\" name=\"new_bucket_size\" value=\"%d\">\
		 (Range: 60-1420 bytes)</td></tr>", bucket_size);

   fprintf(f, "<tr><td><b>Confirm Save</b></td><td></td>\
		<td><input type=\"checkbox\" name=\"conf_sub\" ></td></tr>");
   fprintf(f, "</table>\n");

   fprintf(f, " <input type=submit value=\"Save\"></input>\n");
   fprintf(f, "</form></td></tr>\n");

   fprintf(f, "</table><br>\n");

   fprintf(f, "<br><br><br><br><hr>\n");

   fprintf(f, "<table border=0> \
                <tr> \
                        <td><center><a href=\"intro.html\"><img border=0 src=\"home.png\"></img></a></center></td> \
			<td><center><img border=0 src=\"configure.png\"></img></center></td> \
                        <td><center><a href=\"main_stats.html\"><img border=0 src=\"stats.png\"></img></a></center></td> \
                        <td><center><a href=\"help.html\"><img border=0 src=\"help.png\"></img></a></center></td> \
                </tr> \
                <tr> \
                        <td><center>Home</center></td> \
			<td bgcolor=FF9933><center><b>Settings</b></center></td> \
                        <td><center>Statistics</center></td> \
                        <td><center>Help</center></td> \
                </tr> \
                </table><br>");
   fprintf(f, "</body></html>\n");
} /* print_html_conf_coal */

void print_html_settings(FILE *f)
{
   //dump_request(stderr);
   web_get_intro_title(f);

   char *coal_en = NULL;
   char *conf_sub = NULL;
   char *comp_en = NULL;
   char *qos_en = NULL;
   char *in_port = NULL;
   char *eg_port = NULL;

   char on[5];
   strcpy(on, "on");

   if(swill_getargs("s(conf_sub)", &conf_sub)){} //Read the values
   if(swill_getargs("s(comp_en)", &comp_en)) {}
   if(swill_getargs("s(coal_en)", &coal_en)) {}
   if(swill_getargs("s(qos_en)", &qos_en)) {}

   if(conf_sub != NULL)
   {
	if(comp_en == NULL)
		compress_enabled = FALSE;
	else
		compress_enabled = TRUE;

	if(coal_en == NULL)
                coalescing_enabled = FALSE;
        else
                coalescing_enabled = TRUE;

	if(qos_en == NULL)
                qos_enabled = FALSE;
        else
                qos_enabled = TRUE;
   }



   fprintf(f, "<font size=\"+1\" face=\"Verdana\" color=AA5088>\
                <center><u><b>Traffic Squeezer - Settings</b></u></center></font><br>\n");

   fprintf(f, "<table border=0 cellpadding=0 cellspacing=0 style=\"font-family:verdana;font-size:90%\">");
   fprintf(f, "<tr><td><b>Configure:</b><br></td></tr> \
	       <tr><td><form action=\"http://127.0.0.1:8080/settings.html\" method=POST>\n");

   fprintf(f, "<table border=0>");

   fprintf(f, "<tr><td><font color=gray>Ingress Port</td><td>%s  %s  %s %s</td>\
		<td><select readonly name=\"in_port\"><option readonly value=\"port1\">%s</option></select>\
		</font></td></tr>\n", HTTP_TAB, HTTP_TAB, HTTP_TAB, HTTP_TAB,ingress_port);

   fprintf(f, "<tr><td><font color=gray>Egress Port</td><td></td>\
		<td><select readonly name=\"eg_port\"><option readonly value=\"port1\">%s</option></select>\
		</font></td></tr>\n", egress_port);


   if(compress_enabled == TRUE)
   {	   fprintf(f, "<tr><td>Enable Compression</td><td></td>\
		<td><input type=\"checkbox\" checked  name=\"comp_en\"></td></tr>");
	   comp_en = on;
   }
   else
   {
	   fprintf(f, "<tr><td>Enable Compression</td><td></td>\
		<td><input type=\"checkbox\" name=\"comp_en\"></td></tr>");
   }

   if(coalescing_enabled == TRUE)
   {	fprintf(f, "<tr><td>Enable Coalescing</td><td></td>\
		<td><input type=\"checkbox\" readonly checked  name=\"coal_en\">\
		 <a href=\"conf_coal.html\"> (configure)</a></td></tr>");
	coal_en = on;
   }
   else
   {
	fprintf(f, "<font color=gray><tr><td>Enable Coalescing</td><td></td>\
		<td><input type=\"checkbox\" readonly name=\"coal_en\">(Currently experimental feature. Still has many limitations.)</td></tr></font>");
   }

#if 0
   if(qos_enabled == TRUE)
   {    fprintf(f, "<tr><td>Enable QoS</td><td></td>\
                <td><input type=\"checkbox\" readonly checked  name=\"qos_en\"></td></tr>");
        coal_en = on;
   }
   else
   {
        fprintf(f, "<font color=gray><tr><td>Enable QoS</td><td></td>\
                <td><input type=\"checkbox\" readonly name=\"qos_en\"></td></tr></font>");
   }
#endif

   fprintf(f, "<tr><td><b>Confirm Save</b></td><td></td>\
		<td><input type=\"checkbox\" name=\"conf_sub\" ></td></tr>");
   fprintf(f, "</table>\n");

   fprintf(f, " <input type=submit value=\"Save\"></input>\n");
   fprintf(f, "</form></td></tr>\n");

   fprintf(f, "</table><br>\n");

   fprintf(f, "<br><br><br><br><hr>\n");

   fprintf(f, "<table border=0> \
                <tr> \
                        <td><center><a href=\"intro.html\"><img border=0 src=\"home.png\"></img></a></center></td> \
			<td><center><img border=0 src=\"configure.png\"></img></center></td> \
                        <td><center><a href=\"main_stats.html\"><img border=0 src=\"stats.png\"></img></a></center></td> \
                        <td><center><a href=\"help.html\"><img border=0 src=\"help.png\"></img></a></center></td> \
                </tr> \
                <tr> \
                        <td><center>Home</center></td> \
			<td bgcolor=FF9933><center><b>Settings</b></center></td> \
                        <td><center>Statistics</center></td> \
                        <td><center>Help</center></td> \
                </tr> \
                </table><br>");
   fprintf(f, "</body></html>\n");
} /* print_html_settings */


