
/* 
 * 
 * common.h -- Traffic Squeezer common utility libraries are defined here
 *
 * Author: Kiran K (2006-2008)
 *         kiran_cyberpro at yahoo dot com
 *
 *
 * Traffic Squeezer is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * Traffic Squeezer is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Zebra; see the file COPYING.  If not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef _COMMON_H_
#define _COMMON_H_

#include <unistd.h>
#include <stdint.h>

#define IN
#define OUT
#define INOUT

typedef unsigned char  BYTE;             /* 8-bit   */
typedef unsigned short BYTEx2;           /* 16-bit  */
typedef unsigned long  BYTEx4;           /* 32-bit  */
typedef double         BYTEx8;           /* 64 -bit */
typedef long double    BYTEx16;          /* 128-bit */


typedef uint64_t u64;
typedef uint32_t u32;
typedef uint16_t u16;
typedef uint8_t u8;
typedef int64_t s64;
typedef int32_t s32;
typedef int16_t s16;
typedef int8_t s8;

#define ZERO 0

#define SET 1
#define RESET 0

#define PYLD_PROSD_NONE       0
#define PYLD_PROSD_COMP       1
#define PYLD_PROSD_COAL       2
#define PYLD_PROSD_COAL_COMP  3


#define MAC_ADDR_LEN  6


#define ETH2_FRAME_PAYLOAD_OFFSET 14
#define ETH2_MAX_MTU              1500


#define TRAFFIC_SQUEEZER_VERSION       "prealpha_0.15.7"
#define RELEASE_DATE                   "19-Apr-2008"
#define CONFIG_FILE_MAX_CMD            2
#define DEFAULT_CONFIG_FILE_PATH       "/etc/trafficsqueezer/trafficsqueezer.cfg"



enum _Boolean_
{ FALSE =0,
  TRUE  =1
};


int hex2num(char c);

int hwaddr_aton(const char *txt, u8 *addr);

void print_mac(BYTE *mac);
BYTEx2 human_readable(BYTEx16 bytes, char *format);

static inline void print_char(char c)
{
        if (c >= 32 && c < 127)
                printf("%c", c);
        else
                printf("<%02x>", c);

}

#endif
