/* 
 * 
 * compress_decompress_engine.c -- Traffic Squeezer Compression and Decompression Engine
 *
 * Author: Kiran K (2006-2008)
 *         kiran_cyberpro at yahoo dot com
 *
 *
 * Traffic Squeezer is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * Traffic Squeezer is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Zebra; see the file COPYING.  If not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
 

#include "common.h"
#include "compress_decompress_engine.h"
#include "rle.h"
#include "lz.h"

#define PKT_MAX_MTU       1580


/* Engine which does multi-stage compression: Last updated 20-Jan-07: Kiran */
int compress(unsigned char *in_buff, size_t in_buff_size, unsigned char *out_buff, size_t *out_buff_size)
{
	unsigned char mid_buff[PKT_MAX_MTU];
	size_t mid_buff_size;
	
	//init buff size which is not known yet
	mid_buff_size = 0;
	*out_buff_size = 0;

	mid_buff_size = (size_t)(RLE_Compress( in_buff, mid_buff, (unsigned int)in_buff_size ));
	if(mid_buff_size==0)
		return FALSE;


	*out_buff_size = (size_t)(LZ_Compress( mid_buff, out_buff, (unsigned int)mid_buff_size ));
	if(*out_buff_size == 0)
		return FALSE;


	return TRUE;
}


/*Engine which does multi-stage de-compression: Last updated: 20-Jan-07: Kiran. K */
int decompress(unsigned char *in_buff, size_t in_buff_size, unsigned char *out_buff, size_t *out_buff_size)
{
        unsigned char mid_buff[PKT_MAX_MTU];
        size_t mid_buff_size;

        //init buff size which is not known yet
        mid_buff_size = 0;
        *out_buff_size = 0;

        mid_buff_size = (size_t)(LZ_Uncompress( in_buff, mid_buff, (unsigned int)in_buff_size));
        if(mid_buff_size==0)
                return FALSE;

        *out_buff_size = (size_t)(RLE_Uncompress( mid_buff, out_buff, (unsigned int)mid_buff_size));
        if(*out_buff_size == 0)
                return FALSE;

        return TRUE;
}




