/*
 *
 * message.c -- Traffic Squeezer message wrapper code
 *
 * Author: Kiran K (2006-2008)
 *         kiran_cyberpro at yahoo dot com
 *
 *
 * Traffic Squeezer is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * Traffic Squeezer is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Zebra; see the file COPYING.  If not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */

#ifndef _MESSAGE_
#define _MESSAGE_


#include "common.h"
#include <linux/ipc.h>
#include <linux/msg.h>
#include <sys/types.h>
#include <signal.h>
#include "stats.h"

#define MESSAGE_TYPE 2

typedef struct _mymsgbuf_ {
        long     mtype;    /* Message type */
        BYTE     msgType;
        ts_stats_t stats;
}mymsgbuf;


enum msgTypes {
 MSG_INGRESS_STATS = 2,
 MSG_EGRESS_STATS = 3,
};



int open_queue( key_t keyval );
int send_message( int qid,  mymsgbuf *qbuf );
int read_message( int qid, long type,  mymsgbuf *qbuf );


#endif

