/*
 *
 * stats.h -- Traffic Squeezer Statistics Handler Code
 *
 * Author: Kiran K (2006-2008)
 *         kiran_cyberpro at yahoo dot com
 *
 *
 * Traffic Squeezer is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * Traffic Squeezer is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Zebra; see the file COPYING.  If not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef _stats_
#define _stats_
#include <stdio.h>
#include "common.h"

#define LOG_FILE_FREQ 300  /* for 1000 entries it takes a snapshot in a log file */
			    /* this can be changed later to time bound */

typedef struct ts_stats_ {
        BYTEx4 rx;
        BYTEx4 tx;
        BYTEx4 comprsedPkts;
	BYTEx4 coalesedPkts;
        BYTEx16 rx_bytes;
        BYTEx16 tx_bytes;
}ts_stats_t;


ts_stats_t stats_ingress_port_stats;
ts_stats_t stats_egress_port_stats;

void init_stats(ts_stats_t stats);
void show_intro();
void print_performance_bar_ingress(BYTEx16 rx_bytes, BYTEx16 tx_bytes);
void print_performance_bar_egress(BYTEx16 rx_bytes, BYTEx16 tx_bytes);
void show_comp_stats(ts_stats_t in_stats, ts_stats_t eg_stats, char *in_port, char *eg_port);
void *stats_thread_start(void *a);
void print_html_comp_stats(FILE *f);
void print_html_coal_stats(FILE *f);
void print_html_qos_stats(FILE *f);




#endif
