/* 
 * 
 * socket.h -- Traffic Squeezer socket wrapper code
 *
 * Author: Kiran K (2006-2008)
 *         kiran_cyberpro at yahoo dot com
 *
 *
 * Traffic Squeezer is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * Traffic Squeezer is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Zebra; see the file COPYING.  If not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef _SOCKET_
#define _SOCKET_

#include "common.h"

int tx_frame(int sock_fd, BYTE *buf, int len);
int rx_frame(int sock_fd, BYTE *buf, size_t *len);

int create_socket(char *device, BYTE *mac);
int create_sockets(int *ingress_port_fd, int *egress_port_fd, char *ingress_prt, \
				char *egress_prt, BYTE *ingress_mac, BYTE *egress_mac);

int close_socket(int sock_fd);





#endif
