
/* 
 * 
 * common.c -- Traffic Squeezer common utility libraries are defined here
 *
 * Author: Kiran K (2006-2008)
 *         kiran_cyberpro at yahoo dot com
 *
 *
 * Traffic Squeezer is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * Traffic Squeezer is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Zebra; see the file COPYING.  If not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "common.h"


int hex2num(char c)
{
        if (c >= '0' && c <= '9')
                return c - '0';
        if (c >= 'a' && c <= 'f')
                return c - 'a' + 10;
        if (c >= 'A' && c <= 'F')
                return c - 'A' + 10;
        return -1;
}



int hwaddr_aton(const char *txt, u8 *addr)
{
        int i;

        for (i = 0; i < 6; i++) {
                int a, b;

                a = hex2num(*txt++);
                if (a < 0)
                        return -1;
                b = hex2num(*txt++);
                if (b < 0)
                        return -1;
                *addr++ = (a << 4) | b;
                if (i < 5 && *txt++ != ':')
                        return -1;
        }

        return 0;
}

void print_mac(BYTE *mac)
{
	printf("[%02x: %02x: %02x: %02x: %02x: %02x]\n", mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]);

}

BYTEx2 human_readable(BYTEx16 bytes, char *format)
{
        BYTEx16 kilo=0x400; /* 1024 - bytes */
        BYTEx16 result=0x00;
        if(bytes>kilo)
        {       bytes = bytes/kilo;
                *format = 'K';
        }
        else
        {
                *format = 'a';
                return (BYTEx2)bytes;

        }
        if(bytes>kilo)
        {
                bytes = bytes/kilo;
                *format = 'M';
        }
        if(bytes>kilo)
        {
                bytes = bytes/kilo;
                *format = 'G';
        }
        if(bytes>kilo)
        {
                bytes = bytes/kilo;
                *format = 'T';
        }
        return (BYTEx2)bytes;
}


