/*
 *
 * file_parser.c -- Traffic Squeezer config file parser code
 *
 * Author: Kiran K (2006-2008)
 *         kiran_cyberpro at yahoo dot com
 *
 *
 * Traffic Squeezer is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * Traffic Squeezer is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Zebra; see the file COPYING.  If not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 * 
 */


/*
 * file_parser.c - Changelog
 * Initial Version (25_May_07) - Debaranjan
 * 
 *
 * Updated (26_May_07) - Kiran
 *  Modified file parsing code reusable APIs
 *  Fixed the invalid file access crash bug.
 *
 * Updated (02_June_07) - Kiran
 * Modified the config file parameter processing
 * -> Added the dynamic config file param registration support
 * -> Added the dynamic config file parameter retrieval method
 *
 */


#include "file_parser.h"

cfg_prm_t cfg_prms[CONFIG_FILE_MAX_CMD];

int init_file_parser()
{
	strcpy(cfg_prms[CFG_PRM_INGRESS_PORT].prm_name, "ingress_port");
	cfg_prms[CFG_PRM_INGRESS_PORT].prm_len = (sizeof("ingress_port")-1);
	strcpy(cfg_prms[CFG_PRM_EGRESS_PORT].prm_name, "egress_port");
        cfg_prms[CFG_PRM_EGRESS_PORT].prm_len = (sizeof("egress_port")-1);
	return TRUE;
}



int parse_config(char *config_file)
{
	FILE *fp;
	char file_line[MAX_BUF], *value;
	int cfg_prm_ctr=0;

	if(config_file==NULL)
		return FALSE;

	fp = fopen(config_file,"r");
	if(fp == NULL) //Configuration file not found or error accessing the same
	{
		return FALSE;
	}
	while (fgets (file_line, MAX_BUF, fp))
    	{
      		value = cmd_make_str (file_line);

	      	/* In case of comment line */
      		if (value == NULL)
			continue;

		/* Added: Kiran (02-June-07)
		 * compare all the config parameters list and if there is a match retrive its 
		 * respective value from the configuration file
                 */ 
		for(cfg_prm_ctr=0; cfg_prm_ctr<CONFIG_FILE_MAX_CMD; cfg_prm_ctr++)
		{	
			if(!strncmp(file_line, cfg_prms[cfg_prm_ctr].prm_name, cfg_prms[cfg_prm_ctr].prm_len)) 
			{
				switch(cfg_prm_ctr)
				{
				  case CFG_PRM_INGRESS_PORT: /* ingress_port */
					 strcpy(ingress_port, value); 
					 break;
				  case CFG_PRM_EGRESS_PORT: /* egress_port */
                                         strcpy(egress_port, value);
					 break;
				  default: break;
				}
				break;
			}
		}
	}
	return TRUE;
}

/* Breaking up string into each command piece. I assume given
   character is separated by a space character. Return value is a
   string which includes char * data element. */
char* cmd_make_str (const char *string)
{
  const char *cp, *start;
  char *token;
  int strlen;
  
  if (string == NULL)
    return NULL;
  
  cp = string;

  /* Skip white spaces. */
  while (isspace ((int) *cp) && *cp != '\0')
    cp++;

  /* Return if there is only white spaces */
  if (*cp == '\0')
    return NULL;

  if (*cp == '!' || *cp == '#')
    return NULL;

  
  /* Copy each command piece */
  while (1) 
    {
      start = cp;
      while (!(isspace ((int) *cp) || *cp == '\r' || *cp == '\n') &&
	     *cp != '\0')
      cp++;
      strlen = cp - start;
      token = (char *)malloc(( strlen + 1)*(sizeof(char)));
      memcpy (token, start, strlen);
      *(token + strlen) = '\0';
      
      while ((isspace ((int) *cp) || *cp == '\n' || *cp == '\r') &&
	     *cp != '\0')
	  cp++;

      if (*cp == '\0')
	return token;
    }
}
